function parseChannel(channel) {
    /*
     * FIXME: this code relies on channels being named in a certain way.
     * Suported format:
     *  - 20.04/arm64/android9plus/devel
     *  - ubports-touch/16.04/rc
     */

    const seiresRegexp = /^[0-9]{2}\.[0-9]{2}$/; /* e.g. 16.04, 20.04 */
    const prettyStabilities = {
        "stable": I18nd.tr("Stable"),
        "rc": I18nd.tr("Release candidate"),
        "devel": I18nd.tr("Development"),
        "daily": I18nd.tr("Daily"),
    };

    let c = channel.split('/');
    let series, prettySeries;
    if (seiresRegexp.test(c[0]))
        series = prettySeries = c[0];
    else if (c[0].startsWith("ut")) {
        series = c[0].substring(2);

        /* Special case for UTNext */
        if (series = "next") {
            series = "99.99";
            prettySeries = "Next";
        }
    } else if (c[1] && seiresRegexp.test(c[1]))
        series = prettySeries = c[1];
    else {
        series = '16.04';
        prettySeries = I18nd.tr("Unknown series");
    }

    let stability = c[c.length - 1];

    let prettyStability = stability;
    if (prettyStabilities[stability])
        prettyStability = prettyStabilities[stability];

    return {
        series,
        stability,
        prettyName: `${prettySeries} ${prettyStability}`,
    };
}
