/*
 * Copyright 2025 UBports Foundation
 *
 * This file is part of lomiri-system-settings.
 *
 * lomiri-system-settings is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * lomiri-system-settings is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored-by: Alfred Neumayer <dev.beidl@gmail.com>
 */
import QtQuick 2.15
import Lomiri.Components 1.3
import Lomiri.Components.Popups 1.3
import Snapd2 1.0

Item {
    id: root

    signal setupComplete()
    signal setupCancelled()

    SnapdClient {
        id: snapd
    }

    function hasSnap(name) {
        let request = snapd.getSnaps();
        request.runSync()

        for (let i = 0; i < request.snapCount; i++) {
            let snap = request.snap(i);
            if (snap.name === name)
                return true;
        }

        return false;
    }

    Component.onCompleted: {
        if (root.hasSnap("cups"))
            return;

        console.log("CUPS setup dialog required")
        PopupUtils.open(dialog)
    }

    Component {
         id: dialog
         Dialog {
             id: dialogue
             title: i18n.tr("Install printing support")
             text: i18n.tr("To support printing, an optional component has to be installed.")
             ProgressBar {
                 id: indeterminateBar
                 indeterminate: true
                 visible: false
             }
             Button {
                 id: continueButton
                 text: i18n.tr("Download & install")
                 color: theme.palette.normal.positive
                 onClicked: {
                     indeterminateBar.visible = true;
                     continueButton.enabled = false;
                     cancelButton.enabled = false;

                     let request = snapd.install("cups");
                     request.complete.connect(function(){
                         if (root.hasSnap("cups")) {
                             PopupUtils.close(dialogue);
                             root.setupComplete();
                         } else {
                             PopupUtils.open(errorDialog);
                         }
                     });
                     request.runAsync();
                 }
             }
             Button {
                 id: cancelButton
                 text: i18n.tr("Not now")
                 onClicked: root.setupCancelled();
             }
         }
    }

    Component {
         id: errorDialog
         Dialog {
             title: i18n.tr("Error occured")
             text: i18n.tr("Failed to activate printer support, please try again later.")
             Button {
                 id: cancelButton
                 text: i18n.tr("OK")
                 onClicked: root.setupCancelled();
             }
         }
    }
}
